<?php
/* @var $szkolenia Szkolenie[] */

function getStatusClass($szkolenie)
{
	if ($szkolenie->czySukces > 0)
		return 'class="success"';
	if ($szkolenie->czySukces == null && !empty($szkolenie->dataRozpoczecia) && strtotime($szkolenie->dataZakonczenia) > time())
		return 'class="continous"';
	if ($szkolenie->czySukces == null && !empty($szkolenie->dataRozpoczecia) && strtotime($szkolenie->dataZakonczenia) < time())
		return 'class="toVerify"';
	if ($szkolenie->czySukces == 0 && !empty($szkolenie->dataRozpoczecia))
		return 'class="failed"';
	if (!empty($szkolenie->idProby) && empty($szkolenie->dataZakonczenia))
		return 'class="bought"';
	return 'class="avileable"';
}

$levelRanking = array(
	0 => 999,
	1 => 0,
	2 => 0,
	3 => 0
);

?>

<style type="text/css">
#centrumSzkolenioweListaDialog .avileable {
	background-color: rgba(0, 0, 0, 0);
}
#centrumSzkolenioweListaDialog .failed {
	background-color: rgba(255, 0, 0, 0.4);
}
#centrumSzkolenioweListaDialog .success {
	background-color: rgba(0, 255, 0, 0.4);
}
#centrumSzkolenioweListaDialog .continous {
	background-color: rgba(255, 255, 0, 0.4);
}
#centrumSzkolenioweListaDialog .toVerify {
	background-color: rgba(0, 0, 255, 0.4);
}
#centrumSzkolenioweListaDialog .disabled {
	color: gray;
}
</style>

<div id="theInteriorLaptop" class="sticker" canvasX="400" canvasY="220" canvasWidth="1200" canvasHeight="600">
	<div id="centrumSzkolenioweListaDialog">
			<table style="visibility: hidden">
			<thead>
				<tr>
					<th>Nazwa</th>
					<th>Poziom</th>
					<th>Cena</th>
					<th>Typ</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
			<?php foreach ($szkolenia as $szkolenie) :
				if (isset($levelRanking[$szkolenie->poziom]))
					$levelRanking[$szkolenie->poziom] += $szkolenie->czySukces;
				else
					$levelRanking[$szkolenie->poziom] = $szkolenie->czySukces;
			if ($levelRanking[$szkolenie->poziom-1] >= 1) : ?>
			<?php // 3 ?>
				<tr <?php echo getStatusClass($szkolenie); ?>>
					<td><?php echo $szkolenie->nazwa; ?></td>
					<td><?php echo $szkolenie->poziomStr; ?></td>
					<td><?php if (empty($szkolenie->czySukces)) echo number_format((float)($szkolenie->cena*(1.0+$vat)),2,","," ") . ' zł'; ?></td>
					<td><?php if ($szkolenie->czyEgzamin) echo 'Egzamin<br/>' . $szkolenie->czasTrwania ?></td>
					<td><?php
					if ($szkolenie->czySukces > 0)
						echo '<a training-id="' . $szkolenie->id . '" class="tsGetMaterials" href="#">MATERIAŁY</a>';
					else if ($szkolenie->czySukces == null && !empty($szkolenie->dataRozpoczecia) && strtotime($szkolenie->dataZakonczenia) > time())
						echo '<a training-id="' . $szkolenie->id . '" class="tsContinueExam" href="#">KONTYNUUJ EGZAMIN</a>';
					else if ($szkolenie->czySukces == null && !empty($szkolenie->dataRozpoczecia) && strtotime($szkolenie->dataZakonczenia) < time())
						echo '<a training-id="' . $szkolenie->id . '" class="tsVerify" href="#">ZWERYFIKUJ</a>';
					else if ($szkolenie->czySukces == 0 && $szkolenie->zgloszone != null)
						echo '<a training-id="' . $szkolenie->id . '" class="tsGetMaterials" href="#">MATERIAŁY</a><br/>
							<b>Oczekiwanie na decyzję</b>';
					else if ($szkolenie->czySukces == 0 && !empty($szkolenie->dataRozpoczecia))
						echo '<a training-id="' . $szkolenie->id . '" class="tsGetMaterials" href="#">MATERIAŁY</a><br/>
							<a training-id="' . $szkolenie->id . '" class="tsRestartExam" href="#">PONÓW PRÓBĘ</a>';
					else if (!empty($szkolenie->idProby) && empty($szkolenie->dataZakonczenia))
						echo '<a training-id="' . $szkolenie->id . '" class="tsGetMaterials" href="#">MATERIAŁY</a><br/>
							<a training-id="' . $szkolenie->id . '" class="tsBeginExam" href="#">EGZAMIN</a>';
					else
						echo '<a training-id="' . $szkolenie->id . '" class="tsBuyAndGetMaterials" href="#">WYKUP</a>';
					?></td>
				</tr>
			<?php	endif; endforeach; ?>
			</tbody>
		</table>
		<div style="font-size: 10px;">Aby egzamin został zaliczony należy odpowiedzieć poprawnie na <?php echo ParametryGry::getValue('EGZAMIN_PROG_ZDAWALNOSCI', 3); ?> z <?php echo ParametryGry::getValue('EGZAMIN_ILOSC_PYTAN', 5); ?> pytań.</div>
	</div>

<script type="text/javascript">
(function()
{
	var hashChanged = false;

	$('#centrumSzkolenioweListaDialog').dialog(
	{
		title: 'Lista szkoleń',
		autoOpen: true,
		show: {
			effect: 'scale', duration: 600,
			complete: function() {
				$('#centrumSzkolenioweListaDialog table').css('visibility', 'visible');
				$('#centrumSzkolenioweListaDialog table').fadeIn(1000);
			}
		},
		hide: {
			effect: 'clip', duration: 500,
			start: function() {
				$('#centrumSzkolenioweListaDialog table').css('visibility', 'hidden');
			}
		},
		close: function() {
			if (!hashChanged)
				window.location.hash = <?php echo json_encode($backInterior); ?>;
			$(this).parent().remove();
		},
		position: {
			my: "center",
			at: "center",
			of: window
		},
		closeOnEscape: false,
		draggable: false,
		resizable: false,
		width: 800,
	});

	$(window).off('hashchange.listaTrening');
	$(window).on('hashchange.listaTrening', function() {
		hashChanged = true;
		if ($('#centrumSzkolenioweListaDialog').hasClass('ui-dialog-content'))
			$('#centrumSzkolenioweListaDialog').dialog('close');
		$(window).off('hashchange.listaTrening');
	});

	function enableCtrls(enable)
	{
		var ctrls = $('.tsGetMaterials, .tsContinueExam, .tsVerify, .tsRestartExam, .tsBeginExam, .tsBuyAndGetMaterials, .ui-dialog-titlebar-close');
		if (enable)
			ctrls.removeClass('disabled');
		else
			ctrls.addClass('disabled');
	}

	//przechodzi do szkolenia
	function gotoMaterials(data)
	{
		if (data.error) {
			showMessage('Błąd', data.error);
		}
		else {
			function openMaterials() {
				var currentHash = window.location.hash.substring(1);
				window.temporatyTrainingData = data.szkolenie;
				window.temporatyTrainingData.previousInterior = currentHash;
				window.location.hash = currentHash.substring(0, currentHash.length-1) + 's';
			}
			if (data.szkolenie && data.szkolenie.faktura) {
				var msg = 'Szkolenie zostało wykupione. Fakturę możesz podejrzeć ' +
					'<a target="_blank" href="<?php echo Yii::app()->createAbsoluteUrl('/student/main/invoice', array('id'=>'')) ?>/'
					+ data.szkolenie.faktura + '">tutaj</a>.'
				showMessage('Szkolenie wykupione', msg, {close:openMaterials});
			}
			else openMaterials();
		}
	}

	//zapytanie o materialy
	function getMaterials(trainingId, buy)
	{
		enableCtrls(false);
		$.ajax({
			type: 'POST',
			url: window.links.studentAjaxGetTrainingMaterials,
			data: {
				szkolenieId: trainingId,
				buy: buy
			},
			success: gotoMaterials,
			complete: function() {
				enableCtrls(true);
			}
		});
	}

	//wykupuje kurs i pobiera materiały
	$('.tsBuyAndGetMaterials').click(function()
	{
		var trainingId = $(this).attr('training-id');

		//zapytaj się
		ask('Zakup szkolenia', 'Czy chcesz zakupić to szkolenie?<br/><br/>' +
			'Za szkolenie zostanie wystawiona faktura.', function()
		{
			getMaterials(trainingId, 1);
		});
		return false;
	});

	//pobiera materiały dla wykupionego kursu
	$('.tsGetMaterials').click(function()
	{
		var trainingId = $(this).attr('training-id');
		getMaterials(trainingId, 0);
		return false;
	});

	//rozpoczyna egzamin -> pobiera pytania itp.
	function beginExam(trainingId, buy)
	{
		enableCtrls(false);
		$.ajax({
			type: 'POST',
			url: window.links.studentAjaxStartExam,
			data: {
				szkolenieId: trainingId,
				buy: buy
			},
			success: function(data){
				if (data.error) {
					showMessage('Błąd', data.error);
				}
				else {
					function openExam() {
						var currentHash = window.location.hash.substring(1);
						window.temporatyExamData = data;
						window.temporatyExamData.previousInterior = currentHash;
						window.location.hash = currentHash.substring(0, currentHash.length-1) + 'b';
					}
					if (data.szkolenie && data.szkolenie.faktura) {
						var msg = 'Szkolenie zostało rozpoczęte. Fakturę możesz podejrzeć ' +
							'<a target="_blank" href="<?php echo Yii::app()->createAbsoluteUrl('/student/main/invoice', array('id'=>'')) ?>/'
							+ data.szkolenie.faktura + '">tutaj</a>.'
						showMessage('Szkolenie wykupione', msg, {close:openExam});
					}
					else openExam();
				}
			},
			complete: function() {
				enableCtrls(true);
			}
		});
	}

	//rozpoczyna / kontynuje wykupiony egzamin
	$('.tsBeginExam').click(function()
	{
		var trainingId = $(this).attr('training-id');
		ask('Powtórz egzamin', 'Czy chcesz teraz powtórzyć egzamin?<br/><br/>' +
			'Za egzamin zostanie wystawiona faktura.', function()
		{
			beginExam(trainingId, 0);
		})
		return false;
	});

	//kontynuj egzamin
	$('.tsContinueExam').click(function()
	{
		var trainingId = $(this).attr('training-id');
		beginExam(trainingId, 0);
		return false;
	});

	//wykup egzamin i do niego podjedź
	$('.tsRestartExam').click(function()
	{
		var trainingId = $(this).attr('training-id');
		ask('Powtórz egzamin', 'Czy chcesz teraz powtówrzyć egzamin?<br/><br/>' +
			'Za egzamin zostanie wystawiona faktura.', function()
		{
			beginExam(trainingId, 1);
		})
		return false;
	});

})();
</script>
